﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using Kz.GammaTech.Cms;
using Kz.GammaTech.X509;
using System.DirectoryServices.Protocols;
using Kz.GammaTech.Ocsp;
using Kz.GammaTech.Asn1.Ocsp;

namespace ExampleVerify
{
    class Program
    {
        static void Main(string[] args)
        {

            FileInfo f = new FileInfo("client1.cer");
            FileStream f1 = f.OpenRead();
            byte[] cert_buf = new byte[f1.Length];
            f1.Read(cert_buf, 0, cert_buf.Length);
            f1.Close();
            LdapDirectoryIdentifier dir_id = new LdapDirectoryIdentifier("192.168.12.6", 62222);
            LdapConnection ldap_connect = new LdapConnection(dir_id);
            ldap_connect.AuthType = AuthType.Basic;
            ldap_connect.Bind();

            ExtendedRequest ldap_req = new ExtendedRequest("1.3.6.1.4.1.6801.11.1.4", cert_buf);

            try
            {

                DirectoryResponse ldap_resp = ldap_connect.SendRequest(ldap_req);
                ExtendedResponse ldap_resp2 = (ExtendedResponse)ldap_resp;
                CmsSignedData signedData = new CmsSignedData(ldap_resp2.ResponseValue);
                byte[] Content = (byte[])signedData.SignedContent.GetContent();
                X509Certificate cert = new X509CertificateParser().ReadCertificate(Content);
                Console.WriteLine("Verified");
            }
            catch (Exception exp)
            {
                Console.WriteLine("Not verified");
            }
                                             
            Console.ReadKey();

        }
    }
}
